<?php
namespace AIOSEO\Plugin\Addon\LinkAssistant\Traits;

use AIOSEO\Plugin\Addon\LinkAssistant\Models;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Contains helper methods for the Debug panel.
 *
 * @since 1.0.0
 */
trait Debug {
	/**
	 * Undismisses all suggestions.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function undismissSuggestions() {
		aioseo()->core->db->update( 'aioseo_links_suggestions' )
		->set( [ 'dismissed' => 0 ] )
		->run();
	}

	/**
	 * Resets all Link Assistant data, except for the settings.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function resetData() {
		aioseo()->core->db->update( 'aioseo_posts' )
			->set(
				[
					'link_scan_date'             => null,
					'link_suggestions_scan_date' => null
				]
			)
			->run();

		aioseo()->core->db->truncate( 'aioseo_links ' )->run();
		aioseo()->core->db->truncate( 'aioseo_links_suggestions' )->run();
	}
}